//Listing 13.14. Przykad hierarchii dziedziczenia dla klas Account
#include <iostream>
using namespace std;

class Account { // klasa bazowa
protected:
  double balance;

public:
  Account(double initBalance = 0)
  { balance = initBalance; }

  double getBal() // odziedziczona bez zmian
  { return balance; }

  void withdraw(double amount) // zdefiniowana ponownie w klasie pochodnej
  { if (balance > amount)
    balance -= amount; }

  void deposit(double amount) // odziedziczona bez zmian
  { balance += amount; }
} ;

class CheckingAccount : public Account { // klasa pochodna
  double fee;

public:
  CheckingAccount(double initBalance)
  { balance = initBalance; fee = 0.2; }

  void withdraw(double amount) // ukrywa metod klasy bazowej
  { if (balance > amount)
    balance = balance - amount - fee; }
} ;

int main()
{
  CheckingAccount a1(1000); // obiekt klasy pochodnej
  a1.withdraw(100); // metoda klasy pochodnej
  a1.deposit(200); // metoda klasy bazowej
  cout << " Kocowe stany kont\n";
  cout << " sprawdzanie obiektu konta: " << a1.getBal() <<endl;
  return 0;
}
